<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Repository;

use Doctrine\Persistence\ObjectRepository;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;

interface WriteRepositoryInterface extends ObjectRepository
{
    public function insertEntity(EntityInterface $entity): void;

    public function updateEntity(EntityInterface $entity): void;

    public function deleteEntity(EntityInterface $entity): void;

    public function deleteEntityById(int|string $id): void;
}
