<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Repository;

use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;

class WriteRepository extends ReadRepository implements WriteRepositoryInterface
{
    public function insertEntity(EntityInterface $entity): void
    {
        $this->getEntityManager()->persist($entity);
        $this->getEntityManager()->flush();
    }

    public function updateEntity(EntityInterface $entity): void
    {
        $this->getEntityManager()->flush();
    }

    public function deleteEntity(EntityInterface $entity): void
    {
        $this->getEntityManager()->remove($entity);
        $this->getEntityManager()->flush();
    }

    public function deleteEntityById(int|string $id): void
    {
        $this->getEntityManager()->remove($this->find($id));
        $this->getEntityManager()->flush();
    }
}
