<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Repository;

trait ReadRepositoryLegacyTrait
{
    protected ?string $defaultAlias = null;

    public function getDefaultAlias(): string
    {
        if ($this->defaultAlias === null) {
            $list = explode('\\', $this->_entityName);
            $this->defaultAlias = strtolower(substr(array_pop($list), 0, 1));
        }

        return $this->defaultAlias;
    }

    /**
     * @param array $criteria
     *
     * @return object|null
     */
    public function tryToFindEntityInIMByCriteria(array $criteria): object|null
    {
        $im = $this->getIdentityMapForRepo();

        foreach ($im as $entity) {
            if ($this->isEntityMatchCriteria($entity, $criteria)) {
                return $entity;
            }
        }

        return null;
    }

    /**
     * @param object $entity
     * @param array  $criteria
     *
     * @return bool
     */
    protected function isEntityMatchCriteria($entity, array $criteria): bool
    {
        foreach ($criteria as $name => $value) {
            if ($this->_class->hasField($name)) {
                if (!$this->matchEntityField($entity, $name, $value)) {
                    return false;
                }

                continue;
            }

            if ($this->_class->hasAssociation($name)) {
                if (!$this->matchEntityAssociation($entity, $name, $value)) {
                    return false;
                }

                continue;
            }
        }

        return true;
    }

    /**
     * @param object $entity
     * @param string $name
     * @param mixed  $value
     *
     * @return bool
     */
    protected function matchEntityField($entity, $name, $value)
    {
        $reflection = new \ReflectionObject($entity);

        if ($reflection->hasProperty($name)) {
            $prop = $reflection->getProperty($name);
            $prop->setAccessible(true);

            return $prop->getValue($entity) === $value;
        }

        return false;
    }

    /**
     * @param object $entity
     * @param string $name
     * @param mixed  $value
     *
     * @return bool
     */
    protected function matchEntityAssociation($entity, string $name, $value): bool
    {
        $reflection = new \ReflectionObject($entity);

        if ($reflection->hasProperty($name)) {
            $prop = $reflection->getProperty($name);
            $prop->setAccessible(true);

            $v = $prop->getValue($entity);

            return (!$value && !$v)
                || $v === $value;
        }

        return false;
    }

    /**
     * @return array
     */
    protected function getIdentityMapForRepo(): array
    {
        $im = $this->getEntityManager()
            ->getUnitOfWork()
            ->getIdentityMap();

        return !empty($im[$this->getEntityName()])
            ? $im[$this->getEntityName()]
            : [];
    }

    public function getTableName(): string
    {
        return $this->_class->getTableName();
    }
}
