<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Repository;

use Doctrine\ORM\EntityRepository;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\Factory\QueryBuilderFactoryInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class ReadRepository extends EntityRepository implements ReadRepositoryInterface
{
    protected QueryBuilderFactoryInterface $queryBuilderFactory;

    public function setQueryBuilderFactory(QueryBuilderFactoryInterface $queryBuilderFactory): static
    {
        $this->queryBuilderFactory = $queryBuilderFactory;

        return $this;
    }

    public function createSelectQueryBuilder($alias = null, $indexBy = null): QueryBuilderInterface
    {
        if ($alias === null) {
            $alias = $this->getDefaultAlias();
        }

        return $this->createEmptyQueryBuilder()
            ->select($alias)
            ->from($this->_entityName, $alias, $indexBy);
    }

    public function createEmptyQueryBuilder(): QueryBuilderInterface
    {
        if ($this->queryBuilderFactory) {
            return $this->queryBuilderFactory->create();
        }

        $className = preg_replace('/\\\\Repository\\\\/S', '\QueryBuilder\\', get_called_class());

        return new $className();
    }

    public function createUpdateQueryBuilder(string $alias): QueryBuilderInterface
    {
        return $this->createEmptyQueryBuilder()
            ->update($this->_entityName, $alias);
    }

    public function createDeleteQueryBuilder(string $alias): QueryBuilderInterface
    {
        return $this->createEmptyQueryBuilder()
            ->delete($this->_entityName, $alias);
    }
}
