<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Repository\Decorator\ReadOnly;

use Doctrine\ORM\EntityManagerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\Factory\QueryBuilderFactoryInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;

class ReadOnlyDecorator implements ReadRepositoryInterface
{
    public function __construct(
        private ReadRepositoryInterface $inner,
        private EntityManagerInterface $entityManager,
    ) {
    }

    public function setQueryBuilderFactory(QueryBuilderFactoryInterface $queryBuilderFactory): static
    {
        $this->inner->setQueryBuilderFactory(...func_get_args());

        return $this;
    }

    public function createEmptyQueryBuilder(): QueryBuilderInterface
    {
        return $this->inner->createEmptyQueryBuilder(...func_get_args());
    }

    public function find($id)
    {
        $entity = $this->inner->find(...func_get_args());
        if ($entity) {
            $this->markAsReadOnly($entity);
        }

        return $entity;
    }

    public function findAll()
    {
        $entities = $this->inner->findAll(...func_get_args());
        foreach ($entities as $entity) {
            $this->markAsReadOnly($entity);
        }

        return $entities;
    }

    public function findBy(array $criteria, ?array $orderBy = null, ?int $limit = null, ?int $offset = null)
    {
        $entities = $this->inner->findBy(...func_get_args());
        foreach ($entities as $entity) {
            $this->markAsReadOnly($entity);
        }

        return $entities;
    }

    public function findOneBy(array $criteria)
    {
        $entity = $this->inner->findOneBy(...func_get_args());
        if ($entity) {
            $this->markAsReadOnly($entity);
        }

        return $entity;
    }

    public function getClassName()
    {
        return $this->inner->getClassName(...func_get_args());
    }

    public function createQueryBuilder(string $alias, $indexBy = null): QueryBuilderInterface
    {
        return $this->inner->createQueryBuilder(...func_get_args());
    }

    public function createUpdateQueryBuilder(string $alias): QueryBuilderInterface
    {
        return $this->inner->createUpdateQueryBuilder(...func_get_args());
    }

    public function createDeleteQueryBuilder(string $alias): QueryBuilderInterface
    {
        return $this->inner->createDeleteQueryBuilder(...func_get_args());
    }

    private function markAsReadOnly(EntityInterface $entity): void
    {
        $this->entityManager->getUnitOfWork()->markReadOnly($entity);
    }
}
