<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\Factory;

use Doctrine\ORM\EntityManagerInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class QueryBuilderFactory implements QueryBuilderFactoryInterface
{
    public function __construct(
        private EntityManagerInterface $entityManager,
        private string $className,
    ) {
    }

    public function create(): QueryBuilderInterface
    {
        return new $this->className($this->entityManager);
    }
}
