<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy;

use MyCLabs\Enum\Enum;

/**
 * @method static EXACT()
 * @method static GREATER()
 * @method static LESS()
 * @method static GREATER_OR_EQUAL()
 * @method static LESS_OR_EQUAL()
 */
class NumberFilterStrategyType extends Enum implements FilterStrategyInterface
{
    /**
     * @var string Exact matching
     */
    public const EXACT = 'exact';

    /**
     * @var string The value must be greater
     */
    public const GREATER = 'greater';

    /**
     * @var string The value must be less
     */
    public const LESS = 'less';

    /**
     * @var string The value must be greater or equal
     */
    public const GREATER_OR_EQUAL = 'greater_or_equal';

    /**
     * @var string The value must be less or equal
     */
    public const LESS_OR_EQUAL = 'less_or_equal';
}
