<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\OrderRule;

use ReflectionException;
use ReflectionObject;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Assembler\FieldNameAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enum\OrderRuleDirection;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;
use XCart\Bundle\DoctrineBridgeBundle\DTO\OrderRule\OrderRuleInterface;

class CommonOrderRuleEnricher implements QueryBuilderOrderRuleEnricherInterface
{
    public function __construct(private FieldNameAssemblerInterface $fieldNameAssembler)
    {
    }

    public function enrich(OrderRuleInterface $filter, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        $reflection = new ReflectionObject($filter);

        foreach ($reflection->getMethods() as $method) {
            if (!str_starts_with($method->getName(), 'get')) {
                continue;
            }

            /** @var ?OrderRuleDirection $value */
            try {
                $value = $method->invoke($filter);
            } catch (ReflectionException) {
                continue;
            }
            if ($value === null) {
                continue;
            }

            $property = lcfirst(
                substr($method->getName(), 3)
            );

            $queryBuilder->addOrderBy(
                $this->fieldNameAssembler->assemble($property),
                $value->getValue()
            );
        }

        return $queryBuilder;
    }
}
