<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Resolver;

use Symfony\Component\DependencyInjection\ServiceLocator;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;

class FilterApplierResolver implements FilterApplierResolverInterface
{
    public function __construct(
        private ServiceLocator $appliers,
    ) {
    }

    public function resolve(string $property, FilterValueInterface $value): ?ApplierInterface
    {
        $className = get_class($value);
        if (!$this->appliers->has($className)) {
            return null;
        }

        return $this->appliers->get($className);
    }
}
