<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\DTO;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;

class FilterListElement
{
    private string $property;

    private ApplierInterface $applier;

    private FilterValueInterface $value;

    public function getProperty(): string
    {
        return $this->property;
    }

    public function setProperty(string $property): static
    {
        $this->property = $property;

        return $this;
    }

    public function getApplier(): ApplierInterface
    {
        return $this->applier;
    }

    public function setApplier(ApplierInterface $applier): static
    {
        $this->applier = $applier;

        return $this;
    }

    public function getValue(): FilterValueInterface
    {
        return $this->value;
    }

    public function setValue(FilterValueInterface $value): static
    {
        $this->value = $value;

        return $this;
    }
}
