<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\StringFilterStrategyType;
use XCart\Bundle\DoctrineBridgeBundle\Helper\DoctrineFormatter;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class StringApplier implements ApplierInterface
{
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        $value = $filterValue->getValue();
        if ($value === null) {
            return $queryBuilder;
        }

        $isExclude = $filterValue->isExclude();
        $strategy  = $filterValue->getStrategy()->getValue();

        $valueKey = sprintf(
            '%s_%s',
            DoctrineFormatter::assembleParameterName($name),
            $strategy
        );

        $whereCnd = $isExclude
            ? "{$name} NOT LIKE :{$valueKey}"
            : "{$name} LIKE :{$valueKey}";

        switch ($strategy) {
            case StringFilterStrategyType::EXACT:
                $whereCnd = $isExclude
                    ? "{$name} <> :{$valueKey}"
                    : "{$name} = :{$valueKey}";

                $queryBuilder->setParameter($valueKey, $value);
                break;
            case StringFilterStrategyType::START:
                $queryBuilder->setParameter($valueKey, $value . '%');
                break;
            case StringFilterStrategyType::END:
                $queryBuilder->setParameter($valueKey, '%' . $value);
                break;
            case StringFilterStrategyType::PARTIAL:
            case StringFilterStrategyType::WORD_START:
                $queryBuilder->setParameter($valueKey, '%' . $value . '%');
                break;
            default:
                $whereCnd = null;
        };

        return $queryBuilder->andWhere($whereCnd);
    }
}
