<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\Range\RangeInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\RangeFilterStrategyType;
use XCart\Bundle\DoctrineBridgeBundle\Helper\DoctrineFormatter;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class RangeApplier implements ApplierInterface
{
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        /** @var RangeInterface $value */
        $value = $filterValue->getValue();
        if (!($value instanceof RangeInterface)) {
            return $queryBuilder;
        }

        /** @var RangeFilterStrategyType $strategy */
        $strategy = $filterValue->getStrategy();
        $valueKey = sprintf('%s_%s', DoctrineFormatter::assembleParameterName($name), $strategy->getValue());

        return match ($strategy->getValue()) {
            RangeFilterStrategyType::INCLUDE_BOTH  => $queryBuilder->andWhere(sprintf('%s BETWEEN :%s1 AND %s2', $name, $valueKey, $valueKey))
                ->setParameter($valueKey . '1', $value->getBegin())
                ->setParameter($valueKey . '2', $value->getEnd()),
            RangeFilterStrategyType::INCLUDE_BEGIN => $queryBuilder->andWhere(sprintf('%s >= :%s', $name, $valueKey))
                ->setParameter($valueKey, $value->getBegin()),
            RangeFilterStrategyType::INCLUDE_END   => $queryBuilder->andWhere(sprintf('%s <= :%s', $name, $valueKey))
                ->setParameter($valueKey, $value->getEnd()),
            default                                => $queryBuilder,
        };
    }
}
