<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\NumberFilterStrategyType;
use XCart\Bundle\DoctrineBridgeBundle\Helper\DoctrineFormatter;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class NumberApplier implements ApplierInterface
{
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        $value = $filterValue->getValue();
        if ($value === null) {
            return $queryBuilder;
        }

        /** @var NumberFilterStrategyType $strategy */
        $strategy = $filterValue->getStrategy();
        $valueKey = sprintf('%s_%s', DoctrineFormatter::assembleParameterName($name), $strategy->getValue());

        return match ($strategy->getValue()) {
            NumberFilterStrategyType::EXACT            => $queryBuilder->andWhere(sprintf('%s = :%s', $name, $valueKey))
                ->setParameter($valueKey, $value),
            NumberFilterStrategyType::GREATER          => $queryBuilder->andWhere(sprintf('%s > :%s', $name, $valueKey))
                ->setParameter($valueKey, $value),
            NumberFilterStrategyType::GREATER_OR_EQUAL => $queryBuilder->andWhere(sprintf('%s >= :%s', $name, $valueKey))
                ->setParameter($valueKey, $value),
            NumberFilterStrategyType::LESS             => $queryBuilder->andWhere(sprintf('%s < :%s', $name, $valueKey))
                ->setParameter($valueKey, $value),
            NumberFilterStrategyType::LESS_OR_EQUAL    => $queryBuilder->andWhere(sprintf('%s <= :%s', $name, $valueKey))
                ->setParameter($valueKey, $value),
            default                                    => $queryBuilder,
        };
    }
}
