<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\ListFilterStrategyType;
use XCart\Bundle\DoctrineBridgeBundle\Helper\DoctrineFormatter;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class ListApplier implements ApplierInterface
{
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        $value = $filterValue->getValue();
        if ($value === null || count($value) === 0) {
            return $queryBuilder;
        }

        /** @var ListFilterStrategyType $strategy */
        $strategy = $filterValue->getStrategy();

        switch ($strategy->getValue()) {
            case ListFilterStrategyType::IN:
                return $queryBuilder
                    ->andWhere("$name IN (:list)")
                    ->add('orderBy', "FIELD({$name}, :list)")
                    ->setParameter('list', $value);

            case ListFilterStrategyType::ALL_IN:
                foreach ($value as $k => $v) {
                    $valueKey = sprintf('%s_%s_%d', DoctrineFormatter::assembleParameterName($name), $strategy->getValue(), $k);
                    $queryBuilder
                        ->andWhere(sprintf('%s = :%s', $name, $valueKey))
                        ->setParameter($valueKey, $v);
                }

                return $queryBuilder;
        }

        return $queryBuilder;
    }
}
