<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList;

use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\QueryBuilderFilterEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\OrderRule\QueryBuilderOrderRuleEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;
use XCart\Bundle\DoctrineBridgeBundle\Transformer\Filter\TransformerInterface as FilterTransformerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Transformer\OrderRule\TransformerInterface as OrderRuleTransformerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\FilterOwnerRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\OrderRuleOwnerRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PaginatorRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class CommonQueryBuilderEnricher implements QueryBuilderEnricherInterface
{
    public function __construct(
        private QueryBuilderFilterEnricherInterface $filterEnricher,
        private QueryBuilderOrderRuleEnricherInterface $orderRuleEnricher,
        private FilterTransformerInterface $filterTransformer,
        private OrderRuleTransformerInterface $orderRuleTransformer,
    ) {
    }

    public function enrich(RequestInterface $request, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        if ($request instanceof PaginatorRequestInterface) {
            $queryBuilder = $this->applyPagination($request, $queryBuilder);
        }

        if ($request instanceof FilterOwnerRequestInterface) {
            $queryBuilder = $this->applyFilter($request, $queryBuilder);
        }

        if ($request instanceof OrderRuleOwnerRequestInterface) {
            $queryBuilder = $this->applyOrderBy($request, $queryBuilder);
        }

        return $queryBuilder;
    }

    private function applyPagination(PaginatorRequestInterface $request, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        if (!is_null($request->getOffset())) {
            $queryBuilder->setFirstResult($request->getOffset());
        }

        if (!is_null($request->getLength())) {
            $queryBuilder->setMaxResults($request->getLength());
        }

        return $queryBuilder;
    }

    private function applyFilter(FilterOwnerRequestInterface $request, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        return $this->filterEnricher->enrich($this->filterTransformer->transform($request->getFilter()), $queryBuilder);
    }

    private function applyOrderBy(OrderRuleOwnerRequestInterface $request, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        return $this->orderRuleEnricher->enrich(
            $this->orderRuleTransformer->transform($request->getOrderRule()),
            $queryBuilder,
        );
    }
}
