<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Reference;
use XCart\Bundle\CommonBundle\Transformer\Transparent\SerializationDeserializationTransformer;
use XCart\Bundle\DoctrineBridgeBundle\Action\GetOneAction;
use XCart\Bundle\LogicBundle\DependencyInjection\Compiler\DataProvider\ActionDataProvider;
use XCart\Bundle\LogicBundle\DependencyInjection\LogicExtension;

class ConfigureActionsPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $actionDataProvider = new ActionDataProvider($container);

        foreach ($actionDataProvider->getActions() as $id => $service) {
            $tags = $service->getTag(LogicExtension::ACTION_TAG);
            if (empty($tags[0]['entity']) || empty($tags[0]['response']) || empty($tags[0]['request'])) {
                continue;
            }

            $actionDefinition = $container->getDefinition($id);
            if (is_a($actionDefinition->getClass(), GetOneAction::class, true)) {
                $this->configureGetOneAction($container, $id, $tags[0]['entity']);
            }
        }
    }

    private function configureGetOneAction(ContainerBuilder $container, string $id, string $entityClassName): void
    {
        $actionDefinition = $container->getDefinition($id);

        // Read repository
        $alias = $container->getAlias($this->buildRepositoryAlias($entityClassName));
        $actionDefinition->setArgument('$readRepository', new Reference((string)$alias));

        if (!isset($actionDefinition->getArguments()['$responseAssembler'])) {
            // Response assembler

            $transparentTransformerId = $id . '.assembler.response.transformer';
            $transparentTransformer = (new Definition(SerializationDeserializationTransformer::class))
                ->setAutowired(true)
                ->setArgument('$outputClassName', $actionDefinition->getTag(LogicExtension::ACTION_TAG)[0]['response']);

            $container->setDefinition($transparentTransformerId, $transparentTransformer);
        }
    }

    private function buildRepositoryAlias(string $entityClassName): string
    {
        return sprintf('%s\_\%sRepository', $entityClassName, 'Read');
    }
}
