<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Decorator\PaginatorRequestNormalizer;

use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PaginatorRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class ItemsPerPageRangeDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private int $minPageSize = 1,
        private int $maxPageSize = PHP_INT_MAX,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        if ($request instanceof PaginatorRequestInterface && $request->getItemsPerPage() !== null) {
            $pageSize = $request->getItemsPerPage();
            $pageSize = max($pageSize, $this->minPageSize);
            $pageSize = min($pageSize, $this->maxPageSize);
            $request->setItemsPerPage($pageSize);
        }

        return $this->inner->run($request);
    }
}
