<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Decorator\PaginatorRequestNormalizer;

use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PaginatorRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class DefaultItemsPerPageDecorator implements ActionInterface
{
    private const DEFAULT_PAGE_SIZE = 100;

    public function __construct(
        private ActionInterface $inner,
        private int $defaultPageSize = self::DEFAULT_PAGE_SIZE,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        if ($request instanceof PaginatorRequestInterface && $request->getItemsPerPage() === null) {
            $request->setItemsPerPage($this->defaultPageSize);
        }

        return $this->inner->run($request);
    }
}
