<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\DataSource;

use Countable;
use XCart\Bundle\DoctrineBridgeBundle\Collection\EntityCollectionInterface;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\CountListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\FindListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;

interface ReadDataSourceInterface extends DataSourceInterface, Countable
{
    public function hasOne(int|string $id): bool;

    public function findOne(int|string $id): ?EntityInterface;

    public function findList(FindListCriteria $criteria): EntityCollectionInterface;

    public function countList(CountListCriteria $criteria): int;

    public function hasList(CountListCriteria $criteria): bool;
}
