<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\DataSource;

use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\QueryBuilderFilterEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\OrderRule\QueryBuilderOrderRuleEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;

class DoctrineWriteDataSource implements ReadDataSourceInterface, WriteDataSourceInterface
{
    use DoctrineReadDataSourceTrait;

    public function __construct(
        protected WriteRepositoryInterface $repository,
        QueryBuilderFilterEnricherInterface $queryBuilderFilterEnricher,
        QueryBuilderOrderRuleEnricherInterface $queryBuilderOrderRuleEnricher,
        string $collectionClassName,
    ) {
        $this->queryBuilderFilterEnricher = $queryBuilderFilterEnricher;
        $this->queryBuilderOrderRuleEnricher = $queryBuilderOrderRuleEnricher;
        $this->collectionClassName = $collectionClassName;
    }

    public function insert(EntityInterface $entity): void
    {
        $this->repository->insertEntity($entity);
    }

    public function update(EntityInterface $entity): void
    {
        $this->repository->updateEntity($entity);
    }

    public function delete(EntityInterface $entity): void
    {
        $this->repository->deleteEntity($entity);
    }

    public function deleteById(int|string $id): void
    {
        $this->repository->deleteEntityById($id);
    }
}
