<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\DataSource;

use XCart\Bundle\DoctrineBridgeBundle\Collection\EntityCollectionInterface;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\CountListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\FindListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\FilterInterface;
use XCart\Bundle\DoctrineBridgeBundle\DTO\OrderRule\OrderRuleInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\QueryBuilderFilterEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\OrderRule\QueryBuilderOrderRuleEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

trait DoctrineReadDataSourceTrait
{
    protected QueryBuilderFilterEnricherInterface $queryBuilderFilterEnricher;

    protected QueryBuilderOrderRuleEnricherInterface $queryBuilderOrderRuleEnricher;

    protected string $collectionClassName;

    public function hasOne(int|string $id): bool
    {
        return $this->createQueryBuilder()
            ->andWhere('entity.id = :id')
            ->setParameter('id', $id)
            ->has();
    }

    public function findOne(int|string $id): ?EntityInterface
    {
        return $this->repository->find($id);
    }

    public function findList(FindListCriteria $criteria): EntityCollectionInterface
    {
        $qb = $this->enrichQueryBuilder($this->createQueryBuilder(), $criteria->getFilter(), $criteria->getOrderRule());

        if ($criteria->getOffset() !== null) {
            $qb->setFirstResult($criteria->getOffset());
        }

        if ($criteria->getLength() !== null) {
            $qb->setMaxResults($criteria->getLength());
        }

        return $this->assembleResult($qb);
    }

    public function countList(CountListCriteria $criteria): int
    {
        return $this->assembleCount(
            $this->enrichQueryBuilder($this->createQueryBuilder(), $criteria->getFilter(), $criteria->getOrderRule())
        );
    }

    public function hasList(CountListCriteria $criteria): bool
    {
        return $this->countList($criteria) > 0;
    }

    public function count(): int
    {
        return $this->assembleCount(
            $this->enrichQueryBuilder($this->createQueryBuilder())
        );
    }

    private function createQueryBuilder(): QueryBuilderInterface
    {
        return $this->repository->createSelectQueryBuilder('entity');
    }

    private function enrichQueryBuilder(QueryBuilderInterface $qb, ?FilterInterface $filter = null, ?OrderRuleInterface $orderRule = null): QueryBuilderInterface
    {
        if ($filter) {
            $qb = $this->queryBuilderFilterEnricher->enrich($filter, $qb);
        }

        if ($orderRule) {
            $qb = $this->queryBuilderOrderRuleEnricher->enrich($orderRule, $qb);
        }

        return $qb;
    }

    private function assembleResult(QueryBuilderInterface $qb): EntityCollectionInterface
    {
        return new $this->collectionClassName($qb->getResult());
    }

    private function assembleCount(QueryBuilderInterface $qb): int
    {
        return $qb->countGroupBySafely();
    }
}
