<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\DataSource;

use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\QueryBuilderFilterEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\OrderRule\QueryBuilderOrderRuleEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;

class DoctrineReadDataSource implements ReadDataSourceInterface
{
    use DoctrineReadDataSourceTrait;

    public function __construct(
        protected ReadRepositoryInterface $repository,
        QueryBuilderFilterEnricherInterface $queryBuilderFilterEnricher,
        QueryBuilderOrderRuleEnricherInterface $queryBuilderOrderRuleEnricher,
        string $collectionClassName,
    ) {
        $this->queryBuilderFilterEnricher = $queryBuilderFilterEnricher;
        $this->queryBuilderOrderRuleEnricher = $queryBuilderOrderRuleEnricher;
        $this->collectionClassName = $collectionClassName;
    }
}
