<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\DataSource\Decorator\ReadOnly;

use Doctrine\ORM\EntityManagerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Collection\EntityCollectionInterface;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\CountListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\FindListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\ReadDataSourceInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;

class ReadOnlyDecorator implements ReadDataSourceInterface
{
    public function __construct(
        private ReadDataSourceInterface $inner,
        private EntityManagerInterface $entityManager,
    ) {
    }

    public function hasOne(int|string $id): bool
    {
        return $this->inner->hasOne(...func_get_args());
    }

    public function findOne(int|string $id): ?EntityInterface
    {
        $entity = $this->inner->findOne(...func_get_args());
        if ($entity) {
            $this->markAsReadOnly($entity);
        }

        return $entity;
    }

    public function findList(FindListCriteria $criteria): EntityCollectionInterface
    {
        $collection = $this->inner->findList(...func_get_args());
        foreach ($collection as $entity) {
            $this->markAsReadOnly($entity);
        }

        return $collection;
    }

    public function countList(CountListCriteria $criteria): int
    {
        return $this->inner->countList(...func_get_args());
    }

    public function hasList(CountListCriteria $criteria): bool
    {
        return $this->inner->hasList(...func_get_args());
    }

    public function count(): int
    {
        return $this->inner->count();
    }

    private function markAsReadOnly(EntityInterface $entity): void
    {
        $this->entityManager->getUnitOfWork()->markReadOnly($entity);
    }
}
