<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\DataSource\Decorator\Pagination;

use XCart\Bundle\DoctrineBridgeBundle\Collection\EntityCollectionInterface;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\CountListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\FindListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\ReadDataSourceInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;

class PaginationDecorator implements ReadDataSourceInterface
{
    public function __construct(
        private ReadDataSourceInterface $inner,
        private int $defaultPageSize,
    ) {
    }

    public function hasOne(int|string $id): bool
    {
        return $this->inner->hasOne(...func_get_args());
    }

    public function findOne(int|string $id): ?EntityInterface
    {
        return $this->inner->findOne(...func_get_args());
    }

    public function findList(FindListCriteria $criteria): EntityCollectionInterface
    {
        $criteria->setOffset(max(0, $criteria->getOffset() ?? 0));
        $pageSize = $criteria->getLength() ? max(1, $criteria->getLength()) : $this->defaultPageSize;

        $count = $this->count();
        $pagesCount = $this->getPagesCount($count, $pageSize);
        if ($pagesCount === 0) {
            return $this->inner->findList(...func_get_args());
        }

        $offset = min($pagesCount - 1, max(0, $criteria->getOffset() ?? 0));
        $criteria->setOffset($this->getRealOffset($offset, $pageSize));

        return $this->inner->findList($criteria);
    }

    public function countList(CountListCriteria $criteria): int
    {
        return $this->inner->countList(...func_get_args());
    }

    public function hasList(CountListCriteria $criteria): bool
    {
        return $this->inner->hasList(...func_get_args());
    }

    public function count(): int
    {
        return $this->inner->count();
    }

    private function getPagesCount(int $count, int $pageSize): int
    {
        return $count > 0 ? ceil($count / $pageSize) : 0;
    }

    private function getRealOffset(?int $offset, int $pageSize): int
    {
        return $pageSize * $offset;
    }
}
