<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value;

use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\StringFilterStrategyType;

class StringValue implements FilterValueInterface
{
    private string $value;

    private StringFilterStrategyType $strategy;

    private bool $exclude = false;

    public function getValue(): string
    {
        return $this->value;
    }

    public function setValue(string $value): static
    {
        $this->value = $value;

        return $this;
    }

    public function getStrategy(): StringFilterStrategyType
    {
        return $this->strategy;
    }

    public function setStrategy(StringFilterStrategyType $strategy): static
    {
        $this->strategy = $strategy;

        return $this;
    }

    public function isExclude(): bool
    {
        return $this->exclude;
    }

    public function setExclude(bool $exclude): static
    {
        $this->exclude = $exclude;

        return $this;
    }
}
