<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value;

use Symfony\Component\Validator\Constraints as Assert;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\ListFilterStrategyType;

class StringListValue implements FilterValueInterface
{
    /**
     * @Assert\All({@Assert\Type("string")})
     */
    private array $value;

    private ListFilterStrategyType $strategy;

    private bool $exclude = false;

    /**
     * @return string[]
     */
    public function getValue(): array
    {
        return $this->value;
    }

    /**
     * @param string[] $value
     */
    public function setValue(array $value): static
    {
        $this->value = $value;

        return $this;
    }

    public function getStrategy(): ListFilterStrategyType
    {
        return $this->strategy;
    }

    public function setStrategy(ListFilterStrategyType $strategy): static
    {
        $this->strategy = $strategy;

        return $this;
    }

    public function isExclude(): bool
    {
        return $this->exclude;
    }

    public function setExclude(bool $exclude): static
    {
        $this->exclude = $exclude;

        return $this;
    }
}
