<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\Range\IntegerRange;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\RangeFilterStrategyType;

class IntegerRangeValue implements FilterValueInterface
{
    private IntegerRange $value;

    private RangeFilterStrategyType $strategy;

    private bool $exclude = false;

    public function getValue(): IntegerRange
    {
        return $this->value;
    }

    public function setValue(IntegerRange $value): static
    {
        $this->value = $value;

        return $this;
    }

    public function getStrategy(): RangeFilterStrategyType
    {
        return $this->strategy;
    }

    public function setStrategy(RangeFilterStrategyType $strategy): static
    {
        $this->strategy = $strategy;

        return $this;
    }

    public function isExclude(): bool
    {
        return $this->exclude;
    }

    public function setExclude(bool $exclude): static
    {
        $this->exclude = $exclude;

        return $this;
    }
}
