<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value;

use DateTimeInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\NumberFilterStrategyType;

class DateTimeValue implements FilterValueInterface
{
    private DateTimeInterface $value;

    private NumberFilterStrategyType $strategy;

    private bool $exclude = false;

    public function getValue(): DateTimeInterface
    {
        return $this->value;
    }

    public function setValue(DateTimeInterface $value): static
    {
        $this->value = $value;

        return $this;
    }

    public function getStrategy(): NumberFilterStrategyType
    {
        return $this->strategy;
    }

    public function setStrategy(NumberFilterStrategyType $strategy): static
    {
        $this->strategy = $strategy;

        return $this;
    }

    public function isExclude(): bool
    {
        return $this->exclude;
    }

    public function setExclude(bool $exclude): static
    {
        $this->exclude = $exclude;

        return $this;
    }
}
