<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Assembler\UpdateOne\Arguments;

use XCart\Bundle\LogicBundle\DTO\Request\PayloadOwnerRequestInterface;

class IdBasedArgumentsAssembler implements ArgumentsAssemblerInterface
{
    public function __construct(
        private string $idFieldName,
    ) {
    }

    public function assemble(PayloadOwnerRequestInterface $request): array
    {
        /** @noinspection PhpUndefinedMethodInspection */
        return [$this->idFieldName => $request->getPayload()->getId()];
    }
}
