<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response;

use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\CommonBundle\Transformer\GeneratedTransparentTransformerInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;

class TransformerWrapperAssembler implements ResponseAssemblerInterface
{
    public function __construct(
        private GeneratedTransparentTransformerInterface $transformer,
    ) {
    }

    public function assemble(EntityInterface $entity): PayloadOwnerResponseInterface
    {
        /** @noinspection PhpIncompatibleReturnTypeInspection */
        return $this->transformer->transform($entity);
    }
}
