<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Assembler\GetList\Response;

use XCart\Bundle\CommonBundle\Transformer\GeneratedTransparentTransformerInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadListOwnerResponseInterface;

class TransformerWrapperAssembler implements ResponseAssemblerInterface
{
    public function __construct(
        private GeneratedTransparentTransformerInterface $transformer,
    ) {
    }

    public function assemble(array $entities): PayloadListOwnerResponseInterface
    {
        /** @noinspection PhpIncompatibleReturnTypeInspection */
        /** @noinspection PhpParamsInspection */
        return $this->transformer->transform($entities);
    }
}
