<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Assembler\GetList\DTO;

class Arguments
{
    private array $criteria = [];

    private array $orderBy = [];

    private ?int $limit = null;

    private ?int $offset = null;

    public function getCriteria(): array
    {
        return $this->criteria;
    }

    public function setCriteria(array $criteria): Arguments
    {
        $this->criteria = $criteria;

        return $this;
    }

    public function getOrderBy(): array
    {
        return $this->orderBy;
    }

    public function setOrderBy(array $orderBy): Arguments
    {
        $this->orderBy = $orderBy;

        return $this;
    }

    public function getLimit(): ?int
    {
        return $this->limit;
    }

    public function setLimit(?int $limit): Arguments
    {
        $this->limit = $limit;

        return $this;
    }

    public function getOffset(): ?int
    {
        return $this->offset;
    }

    public function setOffset(?int $offset): Arguments
    {
        $this->offset = $offset;

        return $this;
    }
}
