<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Assembler\GetList\Criteria;

use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\FindListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\Factory\DataSource\DTO\FindListCriteriaFactory;
use XCart\Bundle\DoctrineBridgeBundle\Transformer\Filter\TransformerInterface as FilterTransformerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Transformer\OrderRule\TransformerInterface as OrderRuleTransformerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\FilterOwnerRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\OrderRuleOwnerRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PaginatorRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class FindListCriteriaAssembler implements FindListCriteriaAssemblerInterface
{
    public function __construct(
        private FindListCriteriaFactory $factory,
        private ?FilterTransformerInterface $filterTransformer,
        private ?OrderRuleTransformerInterface $orderRuleTransformer,
    ) {
    }

    public function assemble(RequestInterface $request): FindListCriteria
    {
        $criteria = $this->factory->create();

        if ($request instanceof FilterOwnerRequestInterface && $this->filterTransformer) {
            $criteria->setFilter($this->filterTransformer->transform($request->getFilter()));
        }

        if ($request instanceof OrderRuleOwnerRequestInterface && $this->orderRuleTransformer) {
            $criteria->setOrderRule($this->orderRuleTransformer->transform($request->getOrderRule()));
        }

        if ($request instanceof PaginatorRequestInterface) {
            $criteria
                ->setOffset(($request->getPageIndex() - 1) * $request->getItemsPerPage())
                ->setLength($request->getItemsPerPage());
        }

        return $criteria;
    }
}
