<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Assembler\DeleteOne\Arguments;

use XCart\Bundle\LogicBundle\DTO\Request\IdBasedRequestInterface;

class IdBasedArgumentsAssembler implements ArgumentsAssemblerInterface
{
    public function __construct(
        private string $idFieldName,
    ) {
    }

    public function assemble(IdBasedRequestInterface $request): array
    {
        return [$this->idFieldName => $request->getId()];
    }
}
