<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Action;

use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use Throwable;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\DeleteOne\Arguments\ArgumentsAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\DeleteOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class DeleteOneAction implements ActionInterface
{
    public function __construct(
        private WriteRepositoryInterface $writeRepository,
        private ArgumentsAssemblerInterface $argumentsAssembler,
        private ResponseAssemblerInterface $responseAssembler,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        /** @noinspection PhpParamsInspection */
        $arguments = $this->argumentsAssembler->assemble($request);

        try {
            $entity = $this->writeRepository->findOneBy($arguments);
        } catch (Throwable $e) {
            return (new DefaultFailedResponse())
                ->setType('Internal error')
                ->setTitle(sprintf('Cannot read entity from DB: %s', $e))
                ->setStatus(HTTPResponse::HTTP_INTERNAL_SERVER_ERROR);
        }

        if (!$entity) {
            return (new DefaultFailedResponse())
                ->setType('Not found')
                ->setTitle('Cannot find entity')
                ->setStatus(HTTPResponse::HTTP_NOT_FOUND);
        }

        try {
            $this->writeRepository->deleteEntity($entity);
        } catch (Throwable $e) {
            return (new DefaultFailedResponse())
                ->setType('Internal error')
                ->setTitle(sprintf('Cannot remove entity: %s', $e))
                ->setStatus(HTTPResponse::HTTP_INTERNAL_SERVER_ERROR);
        }

        return $this->responseAssembler->assemble($entity);
    }
}
