<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DoctrineBridgeBundle\Action;

use InvalidArgumentException;
use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use Throwable;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\CreateOne\Entity\EntityAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class CreateOneAction implements ActionInterface
{
    public function __construct(
        private WriteRepositoryInterface $writeRepository,
        private EntityAssemblerInterface $entityAssembler,
        private ResponseAssemblerInterface $responseAssembler,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        try {
            /** @noinspection PhpParamsInspection */
            $entity = $this->entityAssembler->assembler($request);
            $this->writeRepository->insertEntity($entity);

            /** @noinspection PhpIncompatibleReturnTypeInspection */
            return $this->responseAssembler->assemble($entity);
        } catch (Throwable $e) {
            if ($e instanceof InvalidArgumentException) {
                return (new DefaultFailedResponse())
                    ->setType('Bad request')
                    ->setTitle($e->getMessage())
                    ->setStatus(HTTPResponse::HTTP_BAD_REQUEST);
            }

            return (new DefaultFailedResponse())
                ->setType('Internal error')
                ->setTitle($e->getMessage())
                ->setStatus(HTTPResponse::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
