<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\CommonBundle\Transformer\Transparent;

use JMS\Serializer\SerializerInterface;

class SerializationDeserializationTransformer implements TransparentTransformerInterface
{
    private const FORMAT = 'json';

    public function __construct(
        private SerializerInterface $serializer,
    ) {
    }

    public function transform(object $input, string $outputClassName): object
    {
        return $this->serializer->deserialize(
            $this->serializer->serialize($input, static::FORMAT),
            $outputClassName,
            static::FORMAT
        );
    }
}
