<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\CommonBundle\Resolver\Exception;

use Exception;

class KeyTypeWrongException extends Exception
{
    public static function build(string $actualType, string $expectedType): static
    {
        return new self(sprintf('Hash key must be "%s" type instead "%s" type', $expectedType, $actualType));
    }
}
