<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\CommonBundle\Helper;

final class TypeHelper
{
    public static function isClassType(string $type): bool
    {
        if (in_array($type, ['bool', 'boolean', 'integer', 'int', 'float', 'double', 'string', 'array', 'resource', 'null'], true)) {
            return false;
        }

        return (bool) preg_match('/^[A-Z\\\\]/S', $type);
    }
}
