<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\CommonBundle\Assembler;

final class PropertyNameAssembler
{
    public static function assembleSnakePropertyName(string $name): string
    {
        return preg_replace_callback(
            '/[A-Z]/S',
            static function (array $matches): string {
                return '_' . strtolower($matches[0]);
            },
            lcfirst($name)
        );
    }

    public static function assembleCamelPropertyName(string $name): string
    {
        return lcfirst($name);
    }
}
