<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\CommonBundle\Assembler;

final class MethodNameAssembler
{
    public static function assembleGetterName(string $fieldName): string
    {
        return 'get' . self::convertUnderscoreToCamelCase($fieldName);
    }

    public static function assembleSetterName(string $fieldName): string
    {
        return 'set' . self::convertUnderscoreToCamelCase($fieldName);
    }

    public static function assembleAdderName(string $fieldName): string
    {
        $name = self::convertUnderscoreToCamelCase($fieldName);

        $name = preg_replace('/ies$/S', 'y', $name);
        $name = preg_replace('/s$/S', '', $name);

        return 'add' . $name;
    }

    public static function isGetter(string $name): bool
    {
        return str_starts_with($name, 'get');
    }

    public static function isSetter(string $name): bool
    {
        return str_starts_with($name, 'set');
    }

    public static function isAdder(string $name): bool
    {
        return str_starts_with($name, 'add');
    }

    public static function getPropertyNameFromGetterName(string $methodName): string
    {
        return lcfirst(substr($methodName, 3));
    }

    public static function getPropertyNameFromSetterName(string $methodName): string
    {
        return lcfirst(substr($methodName, 3));
    }

    public static function getPropertyNameFromAdderName(string $methodName): string
    {
        return lcfirst(substr($methodName, 3));
    }

    public static function convertUnderscoreToCamelCase(string $string): string
    {
        return str_replace(' ', '', ucwords(str_replace('_', ' ', $string)));
    }
}
