<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\CommonBundle\Assembler;

final class ClassNameAssembler
{
    public static function assembleNamespace(string $className): string
    {
        return substr(trim($className, '\\'), 0, strrpos($className, '\\'));
    }

    public static function assembleShortName(string $className): string
    {
        return substr(trim($className, '\\'), strrpos($className, '\\') + 1);
    }

    public static function isFullClassName(string $className): bool
    {
        $parts = explode('\\', $className);
        if (count($parts) === 1) {
            return false;
        }

        return count(preg_grep('/^[A-Z][a-zA-Z0-9]+$/S', $parts, PREG_GREP_INVERT)) === 0;
    }
}
