<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\OrderRule;

use ApiPlatform\Api\FilterInterface as BaseFilterInterface;
use XCart\Bundle\APIPlatformBridgeBundle\Filter\OperationSpecificFilterInterface;
use XCart\Bundle\LogicBundle\DTO\Request\OrderRule\OrderRuleInterface as LogicOrderRuleInterface;
use XCart\Bundle\CommonBundle\Assembler\MethodNameAssembler;
use XCart\Bundle\LogicBundle\Enum\OrderRuleDirection;

class OrderRule implements BaseFilterInterface, OrderRuleInterface, OperationSpecificFilterInterface
{
    public function __construct(
        private array $properties = [],
        protected array $operations = [],
    ) {
    }

    public function enrich(
        LogicOrderRuleInterface $filter,
        string $resourceClass,
        string $operationName,
        array $context,
    ): void {
        foreach ($this->properties as $name => $strategy) {
            $key = sprintf('order_by.%s', $name);
            if (isset($context['filters'][$key])) {
                $setterName = MethodNameAssembler::assembleSetterName($name);
                $filter->$setterName(OrderRuleDirection::from($context['filters'][$key]));
            }
        }
    }

    public function getDescription(string $resourceClass): array
    {
        $result = [];

        foreach ($this->properties as $name => $strategy) {
            $id = sprintf('order_by.%s', $name);
            $result[$id] = [
                'property' => $id,
                'required' => false,
                'schema'   => [
                    'type' => 'string',
                    'enum' => ['asc', 'desc'],
                ],
            ];
        }

        return $result;
    }

    public function getOperations(): array
    {
        return $this->operations;
    }
}
