<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Filter;

use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\FilterValueInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\StringValue;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\FilterStrategyInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\StringFilterStrategyType;

class StringFilter extends AbstractTypedFilter
{
    protected function buildStrategyDeclaration(string $name, string $id, array $strategies): array
    {
        $result = parent::buildStrategyDeclaration($name, $id, $strategies);

        $result['schema']['default'] = StringFilterStrategyType::EXACT;

        return $result;
    }

    /**
     * @param string                   $value
     * @param StringFilterStrategyType $strategy
     * @param bool                     $exclude
     *
     * @return StringValue
     */
    protected function cast(mixed $value, FilterStrategyInterface $strategy, bool $exclude): FilterValueInterface
    {
        return (new StringValue())
            ->setValue((string)$value)
            ->setStrategy($strategy)
            ->setExclude($exclude);
    }

    protected function getType(): string
    {
        return 'string';
    }

    protected function assembleStrategy(?string $strategyCode): FilterStrategyInterface
    {
        if (!empty($strategyCode)) {
            return StringFilterStrategyType::from($strategyCode);
        }

        if ($this->strategies) {
            reset($this->strategies);
            $firstStrategy = current($this->strategies);

            return StringFilterStrategyType::from($firstStrategy);
        }

        return StringFilterStrategyType::EXACT();
    }
}
