<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Filter;

use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\FilterValueInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\IntegerRangeValue;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\Range\IntegerRange;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\FilterStrategyInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\RangeFilterStrategyType;

class IntegerRangeFilter extends AbstractTypedRangeFilter
{
    /**
     * @param int[]                   $value
     * @param RangeFilterStrategyType $strategy
     * @param bool                    $exclude
     *
     * @return IntegerRangeValue
     */
    protected function cast(mixed $value, FilterStrategyInterface $strategy, bool $exclude): FilterValueInterface
    {
        return (new IntegerRangeValue())
            ->setValue((new IntegerRange())->setBegin($value['begin'] ?? null)->setEnd($value['end'] ?? null))
            ->setStrategy($strategy)
            ->setExclude($exclude);
    }

    protected function getType(): string
    {
        return 'int';
    }

    protected function getSwaggerType(): string
    {
        return 'integer';
    }
}
