<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Filter;

use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\FilterValueInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\IntegerValue;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\FilterStrategyInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\NumberFilterStrategyType;

class IntegerFilter extends AbstractTypedFilter
{
    protected function buildStrategyDeclaration(string $name, string $id, array $strategies): array
    {
        $result = parent::buildStrategyDeclaration($name, $id, $strategies);

        $result['schema']['default'] = NumberFilterStrategyType::EXACT;

        return $result;
    }

    /**
     * @param int                      $value
     * @param NumberFilterStrategyType $strategy
     * @param bool                     $exclude
     *
     * @return IntegerValue
     */
    protected function cast(mixed $value, FilterStrategyInterface $strategy, bool $exclude): FilterValueInterface
    {
        return (new IntegerValue())
            ->setValue((int)$value)
            ->setStrategy($strategy)
            ->setExclude($exclude);
    }

    protected function getType(): string
    {
        return 'int';
    }

    protected function getSwaggerType(): string
    {
        return 'integer';
    }

    protected function assembleStrategy(?string $strategyCode): FilterStrategyInterface
    {
        if (!empty($strategyCode)) {
            return NumberFilterStrategyType::from($strategyCode);
        }

        if ($this->strategies) {
            reset($this->strategies);
            $firstStrategy = current($this->strategies);

            return NumberFilterStrategyType::from($firstStrategy);
        }

        return NumberFilterStrategyType::EXACT();
    }
}
