<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Filter;

use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\FilterValueInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\IntegerListValue;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\FilterStrategyInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\ListFilterStrategyType;

class IntegerEnumerationFilter extends StringFilter
{
    protected function buildDeclaration(string $name, string $id): array
    {
        $result = parent::buildDeclaration($name, $id);

        $result['schema']['example'] = '1,2,3';

        return $result;
    }

    /**
     * @param string                 $value
     * @param ListFilterStrategyType $strategy
     * @param bool                   $exclude
     *
     * @return IntegerListValue
     */
    protected function cast(mixed $value, FilterStrategyInterface $strategy, bool $exclude): FilterValueInterface
    {
        $enumeration = explode(',', $value);
        $enumeration = array_map('trim', $enumeration);
        $enumeration = array_filter($enumeration);
        $enumeration = array_map(static fn($item) => (int)$item, $enumeration);

        return (new IntegerListValue())
            ->setValue($enumeration)
            ->setStrategy($strategy)
            ->setExclude($exclude);
    }

    protected function assembleStrategy(?string $strategyCode): FilterStrategyInterface
    {
        if (!empty($strategyCode)) {
            return ListFilterStrategyType::from($strategyCode);
        }

        if ($this->strategies) {
            reset($this->strategies);
            $firstStrategy = current($this->strategies);

            return ListFilterStrategyType::from($firstStrategy);
        }

        return ListFilterStrategyType::IN();
    }
}
