<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Filter;

use XCart\Bundle\LogicBundle\Enum\FilterStrategy\FilterStrategyInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\NumberFilterStrategyType;

class IdIntegerFilter extends IntegerFilter
{
    protected function buildDeclaration(string $name, string $id): array
    {
        $result = parent::buildDeclaration($name, $id);

        $result['schema']['minimum'] = 1;

        return $result;
    }


    protected function assembleStrategy(?string $strategyCode): FilterStrategyInterface
    {
        return NumberFilterStrategyType::EXACT();
    }
}
