<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Filter;

use ApiPlatform\Core\Exception\InvalidArgumentException;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\FilterValueInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\IntegerListValue;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\FilterStrategyInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\ListFilterStrategyType;

class IdIntegerEnumerationFilter extends IntegerEnumerationFilter
{
    /**
     * @param string                 $value
     * @param ListFilterStrategyType $strategy
     * @param bool                   $exclude
     *
     * @return IntegerListValue
     */
    protected function cast(mixed $value, FilterStrategyInterface $strategy, bool $exclude): FilterValueInterface
    {
        $enumeration  = [];
        $filterValues = explode(',', $value);

        foreach ($filterValues as $filterValue) {
            $intFilterValue = (int) $filterValue;

            if ($intFilterValue <= 0) {
                throw new InvalidArgumentException("\"{$filterValue}\" has a wrong format. Value should be a number greater than zero");
            }

            $enumeration[] = $intFilterValue;
        }

        return (new IntegerListValue())
            ->setValue($enumeration)
            ->setStrategy($strategy)
            ->setExclude($exclude);
    }
}
