<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Filter;

use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\FilterValueInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\FloatRangeValue;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\Range\FloatRange;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\FilterStrategyInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\RangeFilterStrategyType;

class FloatRangeFilter extends AbstractTypedRangeFilter
{
    /**
     * @param float[]                 $value
     * @param RangeFilterStrategyType $strategy
     * @param bool                    $exclude
     *
     * @return FloatRangeValue
     */
    protected function cast(mixed $value, FilterStrategyInterface $strategy, bool $exclude): FilterValueInterface
    {
        return (new FloatRangeValue())
            ->setValue((new FloatRange())->setBegin($value['begin'] ?? null)->setEnd($value['end'] ?? null))
            ->setStrategy($strategy)
            ->setExclude($exclude);
    }

    protected function getType(): string
    {
        return 'float';
    }

    protected function getSwaggerType(): string
    {
        return 'number';
    }
}
